package ru.yandex.chemodan.app.videostreaming;

import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

import ru.yandex.misc.log.log4j.YandexPatternLayout;
import ru.yandex.misc.log.log4j.YandexPatternParser;
import ru.yandex.misc.net.HostnameUtils;
import ru.yandex.misc.regex.Matcher2;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author metal
 */
public class VideoStreamingFFmpegLogLayout extends YandexPatternLayout {
    private static final String PATTERN =
            String.format("%s\t%%R\tlogtime=%%d{yyyy-MM-dd HH:mm:ss,SSS}\t%%m%%n",
                    HostnameUtils.localHostname()
            );

    public VideoStreamingFFmpegLogLayout() {
        super(PATTERN);
    }

    @Override
    protected PatternParser createPatternParser(String s) {
        return new YandexPatternParser(s) {
            @Override
            protected void finalizeConverter(char c) {
                if (c == 'R') {
                    addConverter(new RequestIdConverter(formattingInfo));
                } else {
                    super.finalizeConverter(c);
                }
            }
        };
    }

    private static class RequestIdConverter extends PatternConverter {
        private static final Pattern2 pattern = Pattern2.compile("#rid=([A-Za-z0-9-]+)");

        public RequestIdConverter(FormattingInfo fi) {
            super(fi);
        }

        @Override
        protected String convert(LoggingEvent event) {
            String ndc = (String) event.getMDC("ndc");

            if (ndc == null) {
                return "-";
            }
            Matcher2 m = pattern.matcher2(ndc);
            return m.find() ? m.group(1).getOrElse("") : "";
        }
    }
}
