package ru.yandex.chemodan.app.videostreaming;

import java.io.IOException;
import java.net.SocketTimeoutException;

import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.videostreaming.cache.MpfsSegmentMeta;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.RuntimeIoException;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class VideoStreamingInternalClientTest {
    private final HttpClient httpClientMock = Mockito.mock(HttpClient.class);

    @Test(expected = RuntimeIoException.class)
    public void returnEmptyOnHttpExecuteIoError() throws IOException {
        Mockito.when(httpClientMock.execute(Mockito.<HttpHost>any(), Mockito.any()))
                .thenThrow(new SocketTimeoutException());
        exerciseGetPrefetchSegment();
    }

    @Test
    public void returnNonEmptyValueOn200Ok() throws IOException {
        BasicHttpResponse response = consBasicHttpResponse(200, "OK");
        Mockito.when(httpClientMock.execute(Mockito.<HttpHost>any(), Mockito.any()))
                .thenReturn(response);
        Assert.some(exerciseGetPrefetchSegment());
    }

    @Test
    public void returnEmptyOnNon200Response() throws IOException {
        Mockito.when(httpClientMock.execute(Mockito.<HttpHost>any(), Mockito.any()))
                .thenReturn(consBasicHttpResponse(404, "Not found"));
        Assert.none(exerciseGetPrefetchSegment());
    }

    private Option<InputStreamSource> exerciseGetPrefetchSegment() {
        DiskStreamingUrlBuilder urlBuilderMock = Mockito.mock(DiskStreamingUrlBuilder.class);
        VideoStreamingInternalClient sut = new VideoStreamingInternalClient(httpClientMock, urlBuilderMock, 80);
        return sut.getPrefetchedSegment("localhost", Mockito.mock(MpfsSegmentMeta.class));
    }

    private static BasicHttpResponse consBasicHttpResponse(int statusCode, String reasonPhrase) {
        return new BasicHttpResponse(new BasicStatusLine(HttpVersion.HTTP_1_1, statusCode, reasonPhrase));
    }
}
