package ru.yandex.chemodan.app.videostreaming;

import org.apache.logging.log4j.Level;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpeg;
import ru.yandex.misc.db.monica.JdbcMetricsSwitch;
import ru.yandex.misc.property.PropertiesHolder;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class VideoStreamingMain extends ChemodanMainSupport {
    public static void main(String[] args) {
        // TODO: extract method for metrics activation and pull it up
        JdbcMetricsSwitch.ENABLED = true;
        JdbcMetricsSwitch.COMMAND_METRICS_ENABLED = true;
        new VideoStreamingMain().runMain(args);
    }

    @Override
    public ListF<String> additionalSpringProfiles() {
        return isIgniteEnabled() ? Cf.list("ignite") : Cf.list();
    }

    private static boolean isIgniteEnabled() {
        return Option.ofNullable(PropertiesHolder.properties().getProperty("ignite.enabled"))
                    .map(Boolean::parseBoolean)
                    .getOrElse(false);
    }

    @Override
    protected void configureLogger() {
        super.configureLogger();

        //noinspection deprecation
        Log4jHelper.appenderBuilder()
                .tskvLog(false)
                .appName(applicationName())
                .name(FFmpeg.FFMPEG_LOGGER_NAME)
                .level(ru.yandex.misc.log.mlf.Level.TRACE)
                .postfix("-ffmpeg")
                .layout(new VideoStreamingFFmpegLogLayout())
                .build();

        Log4jHelper.configureNonAdditiveLogger(FFmpeg.FFMPEG_LOGGER_NAME, Level.TRACE);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "videostreaming");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(VideoStreamingConfig.class);
    }
}
