package ru.yandex.chemodan.app.videostreaming.admin.ffmpegargs;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.argfiller.FFmpegArgFillerZkRegistry;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
public class FFmpegArgsAdminConfig {
    @Autowired
    private AdminApp adminApp;

    @Autowired
    private FFmpegArgFillerZkRegistry zkRegistry;

    @Bean
    public FFmpegArgsAdminPage ffmpegArgsAdminPage() {
        FFmpegArgsAdminPage page = new FFmpegArgsAdminPage(zkRegistry);
        adminApp.registerAdminPage("FFmpeg args", Option.of("Streaming"), page);
        return page;
    }
}
