package ru.yandex.chemodan.app.videostreaming.admin.ffmpegargs;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.argfiller.FFmpegArgFillerZkRegistry;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.argfiller.ZkJsFFmpegArgFiller;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.EmptyContentPojo;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.thread.ThreadUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@ActionContainer
public class FFmpegArgsAdminPage {
    private static final String URL_PREFIX = "/streaming-ffmpeg-args";

    private final FFmpegArgFillerZkRegistry zkRegistry;

    public FFmpegArgsAdminPage(FFmpegArgFillerZkRegistry zkRegistry) {
        this.zkRegistry = zkRegistry;
    }

    @ZAction(file = "FFmpegArgsAdminPage.xsl", defaultAction = true)
    @Path(URL_PREFIX)
    public ContentPojo index(@RequestParam("name") Option<String> nameO) {
        CollectionF<ZkJsFFmpegArgFiller> zkArgFillers = zkRegistry.getAll();
        return new ContentPojo(zkArgFillers.sortedBy(ZkJsFFmpegArgFiller::getName),
                nameO.filterMap(name -> zkArgFillers.find(filler -> name.equals(filler.getName())))
                        .getOrElse(ZkJsFFmpegArgFiller.EMPTY)
        );
    }

    @ZAction(file = "FFmpegArgsAdminPage.xsl")
    @Path(value = URL_PREFIX + "/set", methods = HttpMethod.POST)
    public EmptyContentPojo set(@RequestParam("name") String name, @RequestParam("script") String script) {
        zkRegistry.put(new ZkJsFFmpegArgFiller(name, script));
        // hack to show update right after redirect (update takes some time)
        ThreadUtils.sleep(250);
        throw new ZRedirectException("/z" + URL_PREFIX + "?name=" + UrlUtils.urlEncode(name));
    }

    @BenderBindAllFields
    @XmlRootElement(name = "content")
    private static class ContentPojo {
        @BenderPart(name = "filler", wrapperName = "fillers")
        final CollectionF<ZkJsFFmpegArgFiller> fillers;

        final ZkJsFFmpegArgFiller current;

        private ContentPojo(CollectionF<ZkJsFFmpegArgFiller> fillers, ZkJsFFmpegArgFiller current) {
            this.fillers = fillers;
            this.current = current;
        }
    }
}
