<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="head-extra">
        <style type="text/css">
            ul#fillers {
                padding: 0;
                list-style-type: none;
            }
        </style>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <div class="col-sm-8">
                    <form class="form-horizontal" method="POST" action="streaming-ffmpeg-args/set">
                        <h3>Change</h3>

                        <div class="control-group">
                            <label class="control-label">Name</label>
                            <div class="controls">
                                <input type="text" name="name" placeholder="Name" value="{current/name}"/>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label" for="description">Script</label>
                            <div class="controls">
                                <textarea name="script" cols="80" rows="20">
                                    <xsl:value-of select="current/script"/>
                                </textarea>
                            </div>
                        </div>
                        <div class="control-group">
                            <div class="controls">
                                <button type="submit" class="btn">Save</button>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="col-sm-4">
                    <xsl:apply-templates select="fillers"/>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="fillers">
        <h3>Arg fillers</h3>

        <ul id="fillers">
            <xsl:apply-templates select="filler"/>
        </ul>
    </xsl:template>

    <xsl:template match="filler">
        <li><a href="streaming-ffmpeg-args?name={name}"><xsl:value-of select="name"/></a></li>
    </xsl:template>
</xsl:stylesheet>
