package ru.yandex.chemodan.app.videostreaming.admin.mediainfo;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.videostreaming.DiskStreamingUrlBuilder;
import ru.yandex.chemodan.app.videostreaming.MpfsSourceMeta;
import ru.yandex.chemodan.app.videostreaming.MpfsSourceMetaParser;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpeg;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsFFmpegSourceProvider;
import ru.yandex.chemodan.videostreaming.framework.hls.videoinfo.StreamingResourceProvider;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
public class MediaInfoAdminConfig {
    @Autowired
    private AdminApp adminApp;

    @Autowired
    private MpfsSourceMetaParser mpfsSourceMetaParser;

    @Autowired
    private FFmpeg ffmpeg;

    @Autowired
    private HlsFFmpegSourceProvider<MpfsSourceMeta> sourceProvider;

    @Autowired
    @SuppressWarnings({"SpringJavaAutowiringInspection", "SpringAutowiredFieldsWarningInspection"})
    private DiskStreamingUrlBuilder urlBuilder;

    @Autowired
    @SuppressWarnings({"SpringJavaAutowiringInspection", "SpringAutowiredFieldsWarningInspection"})
    private StreamingResourceProvider<MpfsSourceMeta> resourceProvider;

    @Bean
    public UrlHelper urlHelper() {
        return new UrlHelper(resourceProvider, urlBuilder);
    }

    @Bean
    public MediaInfoAdminPage streamingAdminPage() {
        MediaInfoAdminPage page = new MediaInfoAdminPage(urlHelper(), mpfsSourceMetaParser, ffmpeg, sourceProvider);
        adminApp.registerAdminPage("Media info", Option.of("Streaming"), page);
        return page;
    }
}
