<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:z="urn:zscript-functions"
        exclude-result-prefixes="z xsl"
        version="2.0">

    <xsl:import href="./MediaInfoAdminPage-common.xsl"/>

    <xsl:template match="page" mode="content">
        <xsl:call-template name="form"/>
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <xsl:apply-templates select="url-meta"/>

        <table class="table-condensed table-striped table-bordered table-fixed">
            <thead>
                <tr>
                    <th></th>
                    <th>cache</th>
                    <th>no-cache</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <th>pleer URL</th>
                    <td>
                        <xsl:call-template name="video-url">
                            <xsl:with-param name="url" select="pleer-with-cache-url"/>
                            <xsl:with-param name="text">pleer with cache</xsl:with-param>
                        </xsl:call-template>
                    </td>
                    <td>
                        <xsl:call-template name="video-url">
                            <xsl:with-param name="url" select="pleer-without-cache-url"/>
                            <xsl:with-param name="text">pleer without cache</xsl:with-param>
                        </xsl:call-template>
                    </td>
                </tr>
                <tr>
                    <th>playlist URL</th>
                    <td>
                        <xsl:call-template name="video-url">
                            <xsl:with-param name="url" select="playlist-with-cache-url"/>
                            <xsl:with-param name="text">playlist with cache</xsl:with-param>
                        </xsl:call-template>
                    </td>
                    <td>
                        <xsl:call-template name="video-url">
                            <xsl:with-param name="url" select="playlist-without-cache-url"/>
                            <xsl:with-param name="text">playlist without cache</xsl:with-param>
                        </xsl:call-template>
                    </td>
                </tr>
            </tbody>
        </table>
    </xsl:template>

    <xsl:template name="video-url">
        <xsl:param name="url"/>
        <xsl:param name="text"/>

        <a href="{$url}">
            <xsl:value-of select="$text"/>
        </a>
    </xsl:template>

    <xsl:template match="url-meta">
        <table class="table-condensed table-striped table-bordered table-fixed">
            <thead>
                <tr>
                    <th>param</th>
                    <th>value</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <th>mulca-id</th>
                    <td><xsl:value-of select="mulca-id"/></td>
                </tr>
                <tr>
                    <th>owner</th>
                    <td><xsl:value-of select="owner"/></td>
                </tr>
                <tr>
                    <th>consumer</th>
                    <td><xsl:value-of select="consumer"/></td>
                </tr>
                <tr>
                    <th>user IP</th>
                    <td><xsl:value-of select="user-ip"/></td>
                </tr>
                <tr>
                    <th>arg filler name</th>
                    <td><xsl:value-of select="arg-filler"/></td>
                </tr>
                <tr>
                    <th>FFmpeg version</th>
                    <td><xsl:value-of select="ffmpeg-version"/></td>
                </tr>
            </tbody>
        </table>
    </xsl:template>
</xsl:stylesheet>
