package ru.yandex.chemodan.app.videostreaming.admin.mediainfo;

import java.net.URI;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.videostreaming.DiskStreamingUrlBuilder;
import ru.yandex.chemodan.app.videostreaming.MpfsSourceMeta;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsResource;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsStreamQuality;
import ru.yandex.chemodan.videostreaming.framework.hls.StreamingUrlParams;
import ru.yandex.chemodan.videostreaming.framework.hls.videoinfo.StreamingResourceProvider;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.http.UriBuilder;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class UrlHelper {
    private static final String PLEER_URL =
            "https://yastatic.net/yandex-video-player-iframe-api/?autoplay=true&auto_quality=false&preload=false";

    private final StreamingResourceProvider<MpfsSourceMeta> resourceProvider;

    private final DiskStreamingUrlBuilder urlBuilder;

    public UrlHelper(StreamingResourceProvider<MpfsSourceMeta> resourceProvider, DiskStreamingUrlBuilder urlBuilder) {
        this.resourceProvider = resourceProvider;
        this.urlBuilder = urlBuilder;
    }

    public URI getPleerUrl(Option<URI> serverUriO, String stid, String... pairs) {
        return new UriBuilder(PLEER_URL)
                .addParam("hq_url", getMasterPlaylistUrl(serverUriO, stid, pairs))
                .build();
    }

    private URI getMasterPlaylistUrl(Option<URI> serverUriO, String stid, String... pairs) {
        return urlBuilder.getMasterPlaylistUrl(
                new MpfsSourceMeta(MulcaId.fromSerializedString(stid)),
                new StreamingUrlParams()
                        .withServerUriO(serverUriO)
                        .withParameters(pairs)
        );
    }

    public URI getPlaylistUrl(Option<URI> serverUriO, String stid, HlsStreamQuality quality, String... pairs) {
        return urlBuilder.getPlaylistUrl(
                new MpfsSourceMeta(MulcaId.fromSerializedString(stid)), quality,
                new StreamingUrlParams()
                        .withServerUriO(serverUriO)
                        .withParameters(pairs)
        );
    }

    public HlsResource getHlsResource(String stid) {
        return resourceProvider.getResource(new MpfsSourceMeta(MulcaId.fromSerializedString(stid)));
    }

    private HlsStreamQuality getBestQuality(String stid) {
        return getHlsResource(stid).getBestQuality();
    }

    public UrlSet getUrlSet(String stid) {
        return new UrlSet(Option.empty(), stid);
    }

    public class UrlSet {
        final Option<URI> serverUriO;

        final String stid;

        private UrlSet(Option<URI> serverUriO, String stid) {
            this.serverUriO = serverUriO;
            this.stid = stid;
        }

        public URI getPleer(String... pairs) {
            return getPleerUrl(serverUriO, stid, pairs);
        }

        public URI getPleerNoCache() {
            return getPleer("delete_cache", "true");
        }

        public URI getBestQualityPlaylist(String... pairs) {
            return getPlaylistUrl(serverUriO, stid, getBestQuality(stid), pairs);
        }

        public URI getBestQualityPlaylistNoCache() {
            return getBestQualityPlaylist("delete_cache", "true");
        }
    }

}
