package ru.yandex.chemodan.app.videostreaming.admin.overrides;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.videostreaming.overrides.TranscodeOverrideConfig;
import ru.yandex.chemodan.app.videostreaming.overrides.TranscodeOverridesRegistry;
import ru.yandex.chemodan.videostreaming.framework.config.FFmpegVersions;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.argfiller.FFmpegArgFillerRegistry;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import(TranscodeOverrideConfig.class)
public class OverridesAdminConfig {
    @Autowired
    private AdminApp adminApp;

    @Autowired
    private TranscodeOverridesRegistry overridesRegistry;

    @Autowired
    private FFmpegArgFillerRegistry argFillerRegistry;

    @Autowired
    private FFmpegVersions ffmpegVersions;

    @Bean
    public OverridesAdminPage overridesAdminPage() {
        OverridesAdminPage adminPage = new OverridesAdminPage(overridesRegistry, argFillerRegistry, ffmpegVersions);
        adminApp.registerAdminPage("Overrides", Option.of("Streaming"), adminPage);
        return adminPage;
    }
}
