package ru.yandex.chemodan.app.videostreaming.admin.overrides;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.videostreaming.overrides.RequestFilter;
import ru.yandex.chemodan.app.videostreaming.overrides.TranscodeOverride;
import ru.yandex.chemodan.app.videostreaming.overrides.TranscodeOverridesRegistry;
import ru.yandex.chemodan.videostreaming.framework.config.FFmpegVersions;
import ru.yandex.chemodan.videostreaming.framework.hls.TranscodeParams;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.argfiller.FFmpegArgFillerRegistry;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.EmptyContentPojo;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.thread.ThreadUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@ActionContainer
public class OverridesAdminPage {
    private static final String URL_PREFIX = "/streaming-overrides";

    private static final TranscodeOverride EMPTY =
            new TranscodeOverride("", new RequestFilter(Cf.list()), TranscodeParams.DEFAULT);

    private final TranscodeOverridesRegistry overridesRegistry;

    private final FFmpegArgFillerRegistry argFillerRegistry;

    private final FFmpegVersions ffmpegVersions;

    public OverridesAdminPage(
            TranscodeOverridesRegistry overridesRegistry,
            FFmpegArgFillerRegistry argFillerRegistry,
            FFmpegVersions ffmpegVersions)
    {
        this.overridesRegistry = overridesRegistry;
        this.argFillerRegistry = argFillerRegistry;
        this.ffmpegVersions = ffmpegVersions;
    }

    @ZAction(file = "OverridesAdminPage.xsl", defaultAction = true)
    @Path(URL_PREFIX)
    public ContentPojo index(@RequestParam("name") Option<String> nameO) {
        return new ContentPojo(
                overridesRegistry.getAll().sortedBy(TranscodeOverride::getName),
                nameO.filterMap(overridesRegistry::getO)
                        .getOrElse(EMPTY),
                argFillerRegistry.getKeys().sorted(),
                ffmpegVersions.getVersions().sorted()
        );
    }

    @ZAction(file = "OverridesAdminPage.xsl")
    @Path(value = URL_PREFIX + "/set", methods = HttpMethod.POST)
    public EmptyContentPojo set(
            @RequestParam("name") String name,
            @RequestParam("enabled") Option<Boolean> enabled,
            @RequestParam("ownerUids") String ownerUidsStr,
            @RequestParam("argFiller") String argFillerName,
            @RequestParam("ffmpegLogEnabled") Option<Boolean> ffmpegLogEnabled,
            @RequestParam("enableFullHd") Option<Boolean> enableFullHd,
            @RequestParam("disableCache") Option<Boolean> disableCache,
            @RequestParam("enableSeparateAudio") Option<Boolean> enableSeparateAudio,
            @RequestParam("useFloatSegmentDurations") Option<Boolean> useFloatSegmentDurations,
            @RequestParam("ffmpegVersion") String ffmpegVersion)
    {
        checkFFmpegVersionIfNotBlank(ffmpegVersion);
        ListF<PassportUid> ownerUids = StringUtils.notBlankO(ownerUidsStr)
                .map(OverridesAdminPage::parseUids)
                .getOrElse(Cf.list());
        overridesRegistry.put(
                new TranscodeOverride(name, new RequestFilter(enabled.getOrElse(false), ownerUids),
                        new TranscodeParams(argFillerName,
                                ffmpegLogEnabled.getOrElse(false),
                                enableFullHd.getOrElse(false),
                                disableCache.getOrElse(false),
                                enableSeparateAudio.getOrElse(false),
                                useFloatSegmentDurations.getOrElse(false),
                                StringUtils.notBlankO(ffmpegVersion)
                        )
                )
        );
        // hack to show update right after redirect (update takes some time)
        ThreadUtils.sleep(250);
        throw new ZRedirectException("/z" + URL_PREFIX + "?name=" + UrlUtils.urlEncode(name));
    }

    private void checkFFmpegVersionIfNotBlank(String version) {
        StringUtils.notBlankO(version)
                .ifPresent(p -> Check.in(version, ffmpegVersions.getVersions()));
    }

    private static ListF<PassportUid> parseUids(String s) {
        return Cf.list(s.split(","))
                .map(StringUtils::trim)
                .map(Long::parseLong)
                .map(PassportUid::new);
    }

    @BenderBindAllFields
    @XmlRootElement(name = "content")
    private static class ContentPojo {
        @BenderPart(name = "override", wrapperName = "overrides")
        final CollectionF<TranscodeOverride> overrides;

        final TranscodeOverride current;

        @BenderPart(name = "arg-filler", wrapperName = "arg-fillers")
        final CollectionF<String> argFillers;

        @BenderPart(name = "ffmpeg-version", wrapperName = "ffmpeg-versions")
        final CollectionF<String> ffmpegVersions;

        ContentPojo(
                CollectionF<TranscodeOverride> overrides,
                TranscodeOverride current,
                CollectionF<String> argFillers,
                CollectionF<String> ffmpegVersions)
        {
            this.overrides = overrides;
            this.current = current;
            this.argFillers = argFillers;
            this.ffmpegVersions = ffmpegVersions;
        }
    }
}
