<xsl:stylesheet version="2.0"
                xmlns:ya="urn:yandex-functions"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="head-extra">
        <style type="text/css">
            ul#overrides {
                padding: 0;
                list-style-type: none;
            }
        </style>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <div class="col-sm-8">
                    <form class="form-horizontal" method="POST" action="streaming-overrides/set">
                        <h3>Change</h3>

                        <div class="control-group">
                            <label class="control-label">Name</label>
                            <div class="controls">
                                <input type="text" name="name" placeholder="name" value="{current/name}"/>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">Overrides enabled</label>
                            <div class="controls">
                                <xsl:copy-of select="ya:checkbox('enabled', 'Активировать настройки',
                                    /page/content/current/filter/enabled = 'true')"/>
                            </div>
                        </div>
                        <xsl:variable name="owner_uids_str" >
                            <xsl:for-each select="current/filter/owner-uids/owner-uid" >
                                <xsl:if test="position() > 1 ">, </xsl:if>
                                <xsl:value-of select="."/>
                            </xsl:for-each>
                        </xsl:variable>
                        <div class="control-group">
                            <label class="control-label">Owner UIDs</label>
                            <div class="controls">
                                <input type="text" name="ownerUids" placeholder="1,2"
                                       value="{$owner_uids_str}"/>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">FFmpeg argument filler</label>
                            <div class="controls">
                                <select name="argFiller">
                                    <xsl:for-each select="arg-fillers/arg-filler">
                                        <option value="{.}">
                                            <xsl:if test="/page/content/current/params/arg-filler-name = .">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            <xsl:value-of select="."/>
                                        </option>
                                    </xsl:for-each>
                                </select>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">FFmpeg log enabled</label>
                            <div class="controls">
                                <xsl:copy-of select="ya:checkbox('ffmpeg-log-enabled', 'Включить лог FFmpeg',
                                    /page/content/current/params/ffmpeg-log-enabled = 'true')"/>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">Enable FullHD</label>
                            <div class="controls">
                                <xsl:copy-of select="ya:checkbox('enable-full-hd', 'Включить FullHD',
                                    /page/content/current/params/enable-full-hd = 'true')"/>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">Disable cache</label>
                            <div class="controls">
                                <xsl:copy-of select="ya:checkbox('disable-cache', 'Выключить кеш (только для отладки!)',
                                    /page/content/current/params/disable-cache = 'true')"/>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">Enable separate audio</label>
                            <div class="controls">
                                <xsl:copy-of select="ya:checkbox('enable-separate-audio',
                                    'Выделить аудио в отдельный плейлист',
                                    /page/content/current/params/enable-separate-audio = 'true')"/>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">Use decimal-floating-point for segment durations</label>
                            <div class="controls">
                                <xsl:copy-of select="ya:checkbox('use-float-segment-durations',
                                    'Использовать дробную часть для длительностей сегментов в HLS-плейлистах',
                                    /page/content/current/params/use-float-segment-durations = 'true')"/>
                            </div>
                        </div>
                        <div class="control-group">
                            <label class="control-label">FFmpeg version</label>
                            <div class="controls">
                                <select name="ffmpegVersion">
                                    <xsl:for-each select="ffmpeg-versions/ffmpeg-version">
                                        <option value="{.}">
                                            <xsl:if test="/page/content/current/params/ffmpeg-version-o = .">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            <xsl:value-of select="."/>
                                        </option>
                                    </xsl:for-each>
                                </select>
                            </div>
                        </div>
                        <div class="control-group">
                            <div class="controls">
                                <button type="submit" class="btn">Save</button>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="col-sm-4">
                    <xsl:apply-templates select="overrides"/>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="overrides">
        <h3>Overrides</h3>

        <ul id="overrides">
            <xsl:apply-templates select="override"/>
        </ul>
    </xsl:template>

    <xsl:template match="override">
        <li><a href="streaming-overrides?name={name}"><xsl:value-of select="name"/></a></li>
    </xsl:template>

    <xsl:function name="ya:checkbox">
        <xsl:param name="name"/>
        <xsl:param name="title"/>
        <xsl:param name="checked"/>

        <div class="checkbox">
            <label>
                <input type="checkbox" name="{$name}" value="true">
                    <xsl:if test="$checked">
                        <xsl:attribute name="checked"/>
                    </xsl:if>
                    <xsl:value-of select="$title"/>
                </input>
            </label>
        </div>
    </xsl:function>
</xsl:stylesheet>
