package ru.yandex.chemodan.app.videostreaming.admin.stidblocker;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.stidblocker.StidBlocker;
import ru.yandex.chemodan.videostreaming.framework.stidblocker.StidBlockerConfiguration;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author friendlyevil
 */
@Configuration
@Import({StidBlockerConfiguration.class})
public class StidBlockerAdminConfig {
    @Autowired
    private AdminApp adminApp;

    @Autowired
    private StidBlocker stidBlocker;

    @Bean
    public StidBlockerAdminPage stidBlockerAdminPage() {
        StidBlockerAdminPage stidBlockerAdminPage = new StidBlockerAdminPage(stidBlocker);
        adminApp.registerAdminPage("Stid blocker", Option.of("Streaming"), stidBlockerAdminPage);
        return stidBlockerAdminPage;
    }
}
