package ru.yandex.chemodan.app.videostreaming.admin.stidblocker;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.chemodan.videostreaming.framework.stidblocker.StidBlocker;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.XmlRootElement;

/**
 * @author friendlyevil
 */
@ActionContainer
public class StidBlockerAdminPage {
    private static final String URL_PREFIX = "/stid-blocker";

    private final StidBlocker stidBlocker;

    public StidBlockerAdminPage(StidBlocker stidBlocker) {
        this.stidBlocker = stidBlocker;
    }

    @ZAction(file = "StidBlockerAdminPage", defaultAction = true)
    @Path(URL_PREFIX)
    public StidsPojo index() {
        return new StidsPojo(stidBlocker.getAllBlocked());
    }

    @Path(value = URL_PREFIX + "/block", methods = HttpMethod.POST)
    public void blockStid(@RequestParam("stid") String stid) {
        stidBlocker.block(stid);
    }

    @Path(value = URL_PREFIX + "/unblock", methods = HttpMethod.POST)
    public void unblockStid(@RequestParam("stid") String stid) {
        stidBlocker.unblock(stid);
    }

    @BenderBindAllFields
    @XmlRootElement(name = "content")
    private static class StidsPojo {
        @BenderPart(name = "stid", wrapperName = "stids")
        final CollectionF<String> stids;

        public StidsPojo(CollectionF<String> stids) {
            this.stids = stids;
        }
    }
}
