<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
                exclude-result-prefixes="#all">
    <xsl:include href="admin://common.xsl"/>

    <xsl:template match="page" mode="content">
        <xsl:call-template name="block"/>
        <xsl:call-template name="unblock"/>
        <xsl:call-template name="stids"/>
    </xsl:template>

    <xsl:template name="block">
        <form class="form-horizontal" method="POST" action="/z/stid-blocker/block">
            <div class="form-group">
                <label class="col-md-4 control-label" for="url">stid</label>
                <div class="col-md-6">
                    <input id="stid" name="stid" type="text" class="form-control"
                           value="{/page/req/query/param[@name='stid']/@value}"/>
                </div>
            </div>
            <div class="form-group">
                <div class="col-sm-offset-4 col-sm-7">
                    <input type="submit" class="btn btn-danger" value="Block" style="margin-right: 12px"/>
                </div>
            </div>
        </form>
    </xsl:template>

    <xsl:template name="unblock">
        <form class="form-horizontal" method="POST" action="/z/stid-blocker/unblock">
            <div class="form-group">
                <label class="col-md-4 control-label" for="url">stid</label>
                <div class="col-md-6">
                    <input id="stid" name="stid" type="text" class="form-control"
                           value="{/page/req/query/param[@name='stid']/@value}"/>
                </div>
            </div>
            <div class="form-group">
                <div class="col-sm-offset-4 col-sm-7">
                    <input type="submit" class="btn btn-danger" value="Unblock" style="margin-right: 12px"/>
                </div>
            </div>
        </form>
    </xsl:template>

    <xsl:template name="stids">
        <div id="main-content">
            <div class="container">
                <div class="col-md-6">
                    <h3>Blocked stids:</h3>

                    <ul>
                        <xsl:for-each select="/page/content/stids/stid">
                            <li>
                                <xsl:value-of select="."/>
                            </li>
                        </xsl:for-each>
                    </ul>

                </div>
            </div>
        </div>
    </xsl:template>
</xsl:stylesheet>
