package ru.yandex.chemodan.app.videostreaming.cache;

import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.annotation.MonicaStaticRegistry;
import ru.yandex.misc.monica.core.blocks.MeterMap;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

class CacheMetrics {

    @MonicaMetric
    @GroupByDefault
    static final MeterMap videoInfoMemHit = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    static final MeterMap videoInfoDbHit = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    static final MeterMap videoInfoMiss = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    static final MeterMap segmentMetaMemHit = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    static final MeterMap segmentMetaDbHit = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    static final MeterMap segmentMetaMiss = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    static final MeterMap segmentIndexesMemHit = new MeterMap();

    @MonicaMetric
    @GroupByDefault
    static final MeterMap segmentIndexesMemMiss = new MeterMap();

    static {
        MonicaStaticRegistry.register(
                CacheMetrics.class,
                new MetricGroupName(
                        "cache",
                        new MetricName("cache"),
                        "Cache metrics"
                )
        );
    }

}
