package ru.yandex.chemodan.app.videostreaming.cache;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.videostreaming.MpfsSourceMeta;
import ru.yandex.chemodan.videostreaming.framework.hls.videoinfo.caching.VideoInfoCache;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;
import ru.yandex.chemodan.videostreaming.framework.util.IntervalRunner;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DiskStreamingVideoInfoCache implements VideoInfoCache<MpfsSourceMeta> {
    private final VideoInfoCacheDao dao;

    private final IntervalRunner lastAccessTimeUpdater;

    public DiskStreamingVideoInfoCache(VideoInfoCacheDao dao, IntervalRunner lastAccessTimeUpdater) {
        this.dao = dao;
        this.lastAccessTimeUpdater = lastAccessTimeUpdater;
    }

    @Override
    public Option<MediaInfo> getO(MpfsSourceMeta request) {
        Option<Tuple2<MediaInfo, Instant>> videoInfoWithLastAccessTimeO =
                dao.getVideoInfoWithLastAccessTimeO(request.getMulcaId());
        lastAccessTimeUpdater.runAsyncIfAppropriate(
                videoInfoWithLastAccessTimeO.map(Tuple2::get2),
                () -> dao.updateLastAccessTime(request.getMulcaId())
        );
        return videoInfoWithLastAccessTimeO.map(Tuple2::get1);
    }

    @Override
    public void put(MpfsSourceMeta request, MediaInfo videoInfo) {
        dao.save(request.getMulcaId(), videoInfo);
    }

    @Override
    public void clearCacheForSource(MpfsSourceMeta sourceMeta) {
        dao.deleteVideoInfoWithMulcaId(sourceMeta.getMulcaId());
    }
}
