package ru.yandex.chemodan.app.videostreaming.cache;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.videostreaming.MpfsSourceMeta;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;
import ru.yandex.chemodan.videostreaming.framework.util.IntervalRunner;
import ru.yandex.inside.mulca.MulcaId;

public class DiskStreamingVideoInfoCacheWithMemoryCache extends DiskStreamingVideoInfoCache {

    private final SoftMap<MulcaId, MediaInfo> cache;

    public DiskStreamingVideoInfoCacheWithMemoryCache(VideoInfoCacheDao dao,
            IntervalRunner lastAccessTimeUpdater, long ttl)
    {
        super(dao, lastAccessTimeUpdater);
        this.cache = new SoftMap<>(ttl);
    }


    @Override
    public Option<MediaInfo> getO(MpfsSourceMeta request) {
        return cache
                .get(request.getMulcaId())
                .map(info -> {
                    CacheMetrics.videoInfoMemHit.inc();
                    return info;
                })
                .orElse(() -> super.getO(request)
                        .map(info -> {
                            CacheMetrics.videoInfoDbHit.inc();
                            cache.put(request.getMulcaId(), info);
                            return info;
                        })
                        .orElse(() -> {
                            CacheMetrics.videoInfoMiss.inc();
                            return Option.empty();
                        }));
    }

}
