package ru.yandex.chemodan.app.videostreaming.cache;

import lombok.val;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple3;
import ru.yandex.chemodan.app.videostreaming.MpfsSourceMeta;
import ru.yandex.chemodan.app.videostreaming.VideoStreamingInternalClient;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsStreamQuality;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.caching.SegmentIndexes;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.chemodan.videostreaming.framework.util.IntervalRunner;
import ru.yandex.inside.mds.Mds;

public class MdsSegmentCacheWithMemoryCache extends MdsSegmentCache {

    private final SoftMap<Tuple3<MpfsSourceMeta, HlsStreamQuality, MediaTime>, SegmentIndexes> indexesCache;
    private final SoftMap<MpfsSegmentMeta, SegmentCacheMeta> metaCache;

    public MdsSegmentCacheWithMemoryCache(SegmentCacheDao segmentCacheDao, Mds mds,
            VideoStreamingInternalClient internalClient,
            IntervalRunner lastAccessTimeUpdater, long ttl)
    {
        super(segmentCacheDao, mds, internalClient, lastAccessTimeUpdater);
        this.indexesCache = new SoftMap<>(ttl);
        this.metaCache = new SoftMap<>(ttl);
    }

    @Override
    protected Option<SegmentCacheMeta> getSegmentCacheMetaO(MpfsSegmentMeta segmentMeta) {
        return metaCache
                .get(segmentMeta)
                .map(meta -> {
                    CacheMetrics.segmentMetaMemHit.inc();
                    return meta;
                })
                .orElse(() -> super.getSegmentCacheMetaO(segmentMeta)
                        .map(meta -> {
                            CacheMetrics.segmentMetaDbHit.inc();
                            metaCache.put(segmentMeta, meta);
                            return meta;
                        })
                        .orElse(() -> {
                            CacheMetrics.segmentMetaMiss.inc();
                            return Option.empty();
                        }));
    }

    @Override
    public SegmentIndexes getCachedSegmentIndexes(MpfsSourceMeta srcMeta, HlsStreamQuality quality,
            MediaTime duration)
    {
        val key = new Tuple3<MpfsSourceMeta, HlsStreamQuality, MediaTime>(srcMeta, quality, duration);
        return indexesCache
                .get(key)
                .map(indexes -> {
                    CacheMetrics.segmentIndexesMemHit.inc();
                    return indexes;
                })
                .getOrElse(() -> {
                    CacheMetrics.segmentIndexesMemMiss.inc();
                    val indexes = super.getCachedSegmentIndexes(srcMeta, quality, duration);
                    indexesCache.put(key, indexes);
                    return indexes;
                });
    }
}
