package ru.yandex.chemodan.app.videostreaming.cache;

import ru.yandex.chemodan.app.videostreaming.MpfsSourceMeta;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsResource;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsSegmentMeta;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsSegmentRegion;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class MpfsSegmentMeta extends HlsSegmentMeta<MpfsSourceMeta> {
    public MpfsSegmentMeta(HlsSegmentMeta<MpfsSourceMeta> segmentMeta) {
        this(segmentMeta.stream, segmentMeta.region, segmentMeta.getSourceMeta());
    }

    public MpfsSegmentMeta(HlsResource.Stream stream, HlsSegmentRegion region, MpfsSourceMeta sourceMeta) {
        super(stream, region, sourceMeta);
    }

    public SegmentCacheId getCacheId() {
        return new SegmentCacheId(getSourceMeta().getMulcaId(), stream.getQuality(), region);
    }
}
