package ru.yandex.chemodan.app.videostreaming.cache;

import java.math.BigDecimal;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.hls.DurationUtil;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsSegmentRegion;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsStreamQuality;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SegmentCacheId extends DefaultObject {
    private final MulcaId mulcaId;

    private final HlsStreamQuality quality;

    private final HlsSegmentRegion region;

    private final Option<String> tagO;

    public SegmentCacheId(MulcaId mulcaId, HlsStreamQuality quality, HlsSegmentRegion region) {
        this(mulcaId, quality, region, Option.empty());
    }

    private SegmentCacheId(MulcaId mulcaId, HlsStreamQuality quality, HlsSegmentRegion region, Option<String> tagO) {
        this.mulcaId = mulcaId;
        this.quality = quality;
        this.region = region;
        this.tagO = tagO;
    }

    public String getMulcaIdWithTag() {
        return tagO.getOrElse("") + mulcaId.toSerializedString();
    }

    public String getQualityStr() {
        return "" + quality;
    }

    public int getIndex() {
        return region.getIndex();
    }

    public BigDecimal getDurationInSeconds() {
        return DurationUtil.toSecondsWith2DecimalPlaces(region.getDuration());
    }

    public SegmentCacheId withTagO(Option<String> tagO) {
        return new SegmentCacheId(mulcaId, quality, region, tagO);
    }
}
