package ru.yandex.chemodan.app.videostreaming.cache;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.videostreaming.MpfsSourceMeta;
import ru.yandex.chemodan.app.videostreaming.overrides.TranscodeOverride;
import ru.yandex.chemodan.app.videostreaming.overrides.TranscodeOverridesRegistry;
import ru.yandex.chemodan.videostreaming.framework.config.FFmpegVersions;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegParams;
import ru.yandex.chemodan.videostreaming.framework.hls.TranscodeParams;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.HlsFFmpegCommandParams;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SegmentCacheIdProvider {
    private static final String SPECIAL_CHAR = "$";

    private final TranscodeOverridesRegistry overridesRegistry;

    private final FFmpegParams ffmpegParams;

    private final HlsFFmpegCommandParams ffmpegCommandParams;

    public SegmentCacheIdProvider(TranscodeOverridesRegistry overridesRegistry, FFmpegParams ffmpegParams,
            HlsFFmpegCommandParams ffmpegCommandParams)
    {
        this.overridesRegistry = overridesRegistry;
        this.ffmpegParams = ffmpegParams;
        this.ffmpegCommandParams = ffmpegCommandParams;
    }

    public SegmentCacheId getCacheId(MpfsSegmentMeta segmentMeta) {
        return segmentMeta.getCacheId()
                .withTagO(getTagO(segmentMeta));
    }

    private Option<String> getTagO(MpfsSegmentMeta segmentMeta) {
        ListF<Object> chunks = getTagChunks(segmentMeta.sourceMeta);
        if (chunks.isEmpty()) {
            return Option.empty();
        }
        String prefix = chunks.map(Object::toString)
                .map(SegmentCacheIdProvider::sanitize)
                .mkString(":");
        return Option.of(SPECIAL_CHAR + prefix + SPECIAL_CHAR);
    }

    private ListF<Object> getTagChunks(MpfsSourceMeta sourceMeta) {
        ListF<Object> result = Cf.arrayList();
        if (!ffmpegCommandParams.getArgFillerName().equals("default")) {
            result.add(ffmpegCommandParams.getArgFillerName());
        }
        if (!ffmpegParams.getFfmpegVersion().equals(FFmpegVersions.VER_3_2)) {
            result.add(ffmpegParams.getFfmpegVersion());
        }
        if (isCacheDisabled(sourceMeta)) {
            sourceMeta.getExpireAt()
                    .ifPresent(expireAt -> result.add(expireAt.getMillis() / 1000));
        }
        return result.unmodifiable();
    }

    private boolean isCacheDisabled(MpfsSourceMeta sourceMeta) {
        return overridesRegistry.getOverrideO(sourceMeta)
                .map(TranscodeOverride::getParams)
                .isMatch(TranscodeParams::isDisableCache);
    }

    private static String sanitize(String s) {
        return s.replaceAll("\\" + SPECIAL_CHAR, "");
    }
}
