package ru.yandex.chemodan.app.videostreaming.cache;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.mds.MdsFileKey;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SegmentCacheMeta extends DefaultObject {
    private final Option<MdsFileKey> keyO;

    private final Option<String> transcodingHostO;

    private final Instant lastAccessTime;

    public SegmentCacheMeta(Option<MdsFileKey> keyO, Option<String> transcodingHostO, Instant lastAccessTime) {
        this.keyO = keyO;
        this.transcodingHostO = transcodingHostO;
        this.lastAccessTime = lastAccessTime;
    }

    public Option<MdsFileKey> getKeyO() {
        return keyO;
    }

    public Option<String> getTranscodingHostO() {
        return transcodingHostO;
    }

    public Instant getLastAccessTime() {
        return lastAccessTime;
    }
}
