package ru.yandex.chemodan.app.videostreaming.config;

import java.io.IOException;
import java.net.URI;
import java.util.function.Supplier;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class AltGateUrlSupplier extends DelayingWorkerServiceBeanSupport implements Supplier<Option<String>> {
    private static final Logger logger = LoggerFactory.getLogger(AltGateUrlSupplier.class);

    private final HttpClient httpClient;

    private final URI hostlistUri;

    private volatile Option<String> gateUrlO = Option.empty();

    public AltGateUrlSupplier(HttpClient httpClient, URI hostlistUri) {
        this.httpClient = httpClient;
        this.hostlistUri = hostlistUri;
    }

    @Override
    public Option<String> get() {
        return gateUrlO;
    }

    @Override
    protected void execute() {
        try {
            this.gateUrlO = Option.of(
                    String.format("http://%s:10010/gate", fetchNewHost())
            );
        } catch(RuntimeException ex) {
            // ignore
        }
    }

    private String fetchNewHost() {
        try {
            return httpClient.execute(new HttpGet(hostlistUri), this::parseResponse);
        } catch (Exception e) {
            logger.error("Failed to update mulcagate host");
            throw ExceptionUtils.translate(e);
        }
    }

    private String parseResponse(HttpResponse response) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        byte[] download = EntityUtils.toByteArray(response.getEntity());
        return mapper.readTree(download)
                .get("host")
                .asText();
    }
}
