package ru.yandex.chemodan.app.videostreaming.config;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import com.xebialabs.restito.builder.stub.StubHttp;
import com.xebialabs.restito.semantics.Action;
import com.xebialabs.restito.semantics.Condition;
import org.apache.http.client.HttpClient;
import org.glassfish.grizzly.http.Method;
import org.joda.time.Duration;
import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.test.StubServerUtils;
import ru.yandex.devtools.test.annotations.YaExternal;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.test.Assert;

public class AltGateUrlSupplierTest {
    @Test
    @YaExternal
    public void testParse() {
        final CompletableFuture<Void> responded = new CompletableFuture<>();
        StubServerUtils.withStubServer((port, stubServer) -> {
            StubHttp.whenHttp(stubServer)
                    .match(Condition.method(Method.GET))
                    .then(Action.custom(input -> {
                        try {
                            input.setStatus(HttpStatus.SC_200_OK);
                            Action.stringContent("{\"host\": \"mulcagate17e.storage.yandex.net\"}")
                                    .apply(input);
                        } finally {
                            responded.complete(null);
                        }
                        return input;
                    }));

            HttpClient httpClient = ApacheHttpClientUtils.singleConnectionClient(Option.empty());
            AltGateUrlSupplier altGateUrlSupplier =
                    new AltGateUrlSupplier(httpClient, new UriBuilder("http://localhost:" + port).build());
            altGateUrlSupplier.setDelay(Duration.ZERO);
            altGateUrlSupplier.setSleepBeforeFirstRun(false);
            altGateUrlSupplier.start();
            try {
                responded.get(10, TimeUnit.SECONDS);
                Thread.sleep(500);
                Assert.some("http://mulcagate17e.storage.yandex.net:10010/gate", altGateUrlSupplier.get());
            } finally {
                altGateUrlSupplier.stop();
            }
        });
    }
}
