package ru.yandex.chemodan.app.videostreaming.config;

import java.net.URI;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HostMappingUtil {
    public static MapF<Option<URI>, URI> parse(String value) {
        if (StringUtils.isBlank(value)) {
            return Cf.map();
        }

        return Cf.x(
                Cf.x(value.split(","))
                        .map(s -> s.split("->"))
                        .toTuple2List(s -> new Tuple2<>(parseUriO(s[0]), parseUri(s[1])))
                        .toJavaLinkedHashMap()
        );
    }

    private static Option<URI> parseUriO(String value) {
        return Option.when(StringUtils.isNotBlank(value), () -> parseUri(value));
    }

    static URI parseUri(String value) {
        URI uri = new UriBuilder(value)
                .build();
        return new UriBuilder()
                .setScheme(uri.getScheme().toLowerCase())
                .setHost(uri.getHost().toLowerCase())
                .build();
    }
}
