package ru.yandex.chemodan.app.videostreaming.config;

import java.net.URI;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HostMappingUtilTest {
    @Test
    public void test() {
        String value = "->HTTPS://disk-Streaming.ape.yandex.NET" +
                ",http://streaming.Qloud.disk.yandex.net/->https://streaming.qloud.disk.YandeX.net/";
        Assert.equals(
                Cf.<Option<URI>, URI>map()
                        .plus1(Option.empty(), consUri("https", "disk-streaming.ape.yandex.net"))
                        .plus1(
                                consUriO("http", "streaming.qloud.disk.yandex.net"),
                                consUri("https", "streaming.qloud.disk.yandex.net"))
                ,
                HostMappingUtil.parse(value)
        );
    }

    private static Option<URI> consUriO(String scheme, String host) {
        return Option.of(consUri(scheme, host));
    }

    private static URI consUri(String scheme, String host) {
        return new UriBuilder()
                .setScheme(scheme)
                .setHost(host)
                .build();
    }
}
