package ru.yandex.chemodan.app.videostreaming.config;

import java.util.function.Supplier;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaGateUrl;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.version.AppName;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import(Tvm2BaseContextConfiguration.class)
public class MulcaConfig {
    @Value("${mulca.gate.url}")
    private String gateUrl;

    @Value("${mulca.gate.hostlist.url}")
    private String mulcaGateHostlistUrl;

    @Value("${mulca.service}")
    private String mulcaService;
    @Value("${mulca.namespace}")
    private String mulcaNamespace;

    @Value("${mulca.gate.host}")
    private String mulcaGateHost;

    @Autowired
    @SuppressWarnings("SpringJavaAutowiringInspection")
    private EnvironmentType environment;

    @Autowired
    @SuppressWarnings({"SpringJavaAutowiringInspection", "SpringAutowiredFieldsWarningInspection"})
    private AppName appName;

    @Bean
    public MulcaClient mulcaClient() {
        MulcaClient.Builder builder = MulcaClient.custom(httpClient(), mulcaGateUrl()).withService(mulcaService)
                .withNamespace(mulcaNamespace);

        return builder.build();
    }

    @Bean
    public MulcaGateUrl mulcaGateUrl() {
        return new MulcaGateUrl(gateUrl, altGateUrlSupplier());
    }

    @Bean
    public Supplier<Option<String>> altGateUrlSupplier() {
        return environment.equals(EnvironmentType.PRODUCTION)
                ? new AltGateUrlSupplier(httpClient(), new UriBuilder(mulcaGateHostlistUrl).build())
                : Option::empty;
    }

    @Bean
    public HttpClient httpClient() {
        return mulcaHttpClientConfigurator().configure();
    }

    @Bean
    @OverridableValuePrefix("mulca")
    public HttpClientConfigurator mulcaHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
