package ru.yandex.chemodan.app.videostreaming.config;

import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.videostreaming.upstreams.MulcaUpstream;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import(MulcaConfig.class)
@RequiredArgsConstructor
public class MulcaUpstreamConfig {
    private final MulcaConfig mulcaConfig;

    @Bean
    public MulcaUpstream diskStorageUpstream() {
        return new MulcaUpstream(mulcaConfig.mulcaClient());
    }
}
