package ru.yandex.chemodan.app.videostreaming.config;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.videostreaming.cache.SegmentCacheDao;
import ru.yandex.chemodan.app.videostreaming.cache.SegmentCacheIdProvider;
import ru.yandex.chemodan.app.videostreaming.cache.VideoInfoCacheDao;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

@Configuration
@Import({JdbcDatabaseConfiguratorContextConfiguration.class})
public class VideoStreamingDaoConfig {
    private final JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;

    private final DataSourceProperties dsProperties;

    private final SegmentCacheIdProvider segmentCacheIdProvider;

    @Autowired
    @SuppressWarnings({"SpringJavaAutowiringInspection", "SpringAutowiredFieldsWarningInspection"})
    private DynamicPropertyManager dynamicPropertyManager;

    @Autowired
    public VideoStreamingDaoConfig(
            JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig,
            DataSourceProperties dsProperties,
            SegmentCacheIdProvider segmentCacheIdProvider)
    {
        this.dbConfiguratorConfig = dbConfiguratorConfig;
        this.dsProperties = dsProperties;
        this.segmentCacheIdProvider = segmentCacheIdProvider;
    }

    @Bean
    public SegmentCacheDao segmentCacheDao() {
        dynamicPropertyManager.addStaticFields(SegmentCacheDao.class);
        return new SegmentCacheDao(jdbcTemplate(), segmentCacheIdProvider);
    }

    @Bean
    public VideoInfoCacheDao videoInfoCacheDao() {
        return new VideoInfoCacheDao(jdbcTemplate());
    }

    @Bean
    public JdbcTemplate3 jdbcTemplate() {
        return dbConfigurator().consTemplate(videostreamingDataSource());
    }

    @Bean
    public JdbcDatabaseConfigurator dbConfigurator() {
        return dbConfiguratorConfig.consJdbcConfigurator(dsProperties);
    }

    @Bean
    public DataSource videostreamingDataSource() {
        return dbConfigurator().configureDataSource();
    }
}
