package ru.yandex.chemodan.app.videostreaming.config;

import java.math.BigDecimal;

import org.mockito.Mockito;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.videostreaming.cache.SegmentCacheId;
import ru.yandex.chemodan.app.videostreaming.cache.SegmentCacheIdProvider;
import ru.yandex.chemodan.boot.ChemodanTestBaseContextConfiguration;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.test.EmbeddedDBDataSourceProperties;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.misc.db.embedded.EmbeddedPostgres;
import ru.yandex.misc.db.embedded.ImportEmbeddedPg;
import ru.yandex.misc.db.embedded.PreparedDbProvider;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import({VideoStreamingDaoConfig.class, VideoStreamingDaoTestConfig.SegmentCacheIdProviderConfig.class})
@ImportEmbeddedPg
public class VideoStreamingDaoTestConfig extends ChemodanTestBaseContextConfiguration {
    @Bean
    @OverridableValuePrefix("videostreaming")
    public DataSourceProperties dataSourceProperties(EmbeddedPostgres embeddedPostgres) {
        return new EmbeddedDBDataSourceProperties(
                PreparedDbProvider.forPreparer("videostreaming", embeddedPostgres)
                        .createDatabase()
        );
    }

    @Override
    protected AppName appName() {
        return new SimpleAppName("disk", "videostreaming");
    }

    @Bean
    public DynamicPropertyManager dynamicPropertyManager() {
        return Mockito.mock(DynamicPropertyManager.class);
    }

    static class SegmentCacheIdProviderConfig {
        @Bean
        public SegmentCacheIdProvider segmentCacheIdProviderConfig() {
            SegmentCacheId cacheIdMock = Mockito.mock(SegmentCacheId.class);
            Mockito.when(cacheIdMock.getMulcaIdWithTag())
                    .thenReturn("");
            Mockito.when(cacheIdMock.getIndex())
                    .thenReturn(1);
            Mockito.when(cacheIdMock.getDurationInSeconds())
                    .thenReturn(new BigDecimal("1.5"));
            Mockito.when(cacheIdMock.getQualityStr())
                    .thenReturn("_720P");
            SegmentCacheIdProvider providerMock = Mockito.mock(SegmentCacheIdProvider.class);
            Mockito.when(providerMock.getCacheId(Mockito.any()))
                    .then(inv -> cacheIdMock);
            return providerMock;
        }
    }
}
