package ru.yandex.chemodan.app.videostreaming.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.videostreaming.MpfsSourceMetaParser;
import ru.yandex.chemodan.util.encrypt.OpenSslAes256CbcCrypter;
import ru.yandex.chemodan.videostreaming.framework.config.StreamingQualifier;
import ru.yandex.chemodan.videostreaming.framework.util.RequestAccessChecker;
import ru.yandex.chemodan.videostreaming.framework.web.HlsServlet;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
public class VideoStreamingRequestConfig {
    @Value("${stid.secret}")
    private String stidSecret;

    @Value("${streaming.internal-hosts}")
    private String internalHostsStr;

    @Bean
    @StreamingQualifier
    public MpfsSourceMetaParser streamingSourceMetaParser() {
        return new MpfsSourceMetaParser(crypter(), accessChecker());
    }

    @Bean
    public OpenSslAes256CbcCrypter crypter() {
        return new OpenSslAes256CbcCrypter(stidSecret);
    }

    @Bean
    public RequestAccessChecker accessChecker() {
        return new RequestAccessChecker(
                Cf.set(internalHostsStr.split(","))
                        .plus("localhost", HostnameUtils.localHostname())
                        .map(String::toLowerCase)
                        .unique(),
                Cf.set("/" + HlsServlet.URL_PREFIX, "/ping")
        );
    }
}
