package ru.yandex.chemodan.app.videostreaming.overrides;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.videostreaming.MpfsSourceMeta;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@BenderBindAllFields
@RequiredArgsConstructor
public class RequestFilter {
    @BenderDefaultValue("true")
    private final boolean enabled;

    @BenderPart(name = "owner-uid", wrapperName = "owner-uids")
    private final ListF<PassportUid> ownerUids;

    public RequestFilter(ListF<PassportUid> ownerUids) {
        this(true, ownerUids);
    }

    public boolean matches(MpfsSourceMeta sourceMeta) {
        return enabled && sourceMeta.getOwnerUid()
                .filterMap(PassportUidOrZero::toPassportUidO)
                .isMatch(ownerUids::containsTs);
    }
}
