package ru.yandex.chemodan.app.videostreaming.overrides;

import lombok.Getter;

import ru.yandex.chemodan.app.videostreaming.MpfsSourceMeta;
import ru.yandex.chemodan.videostreaming.framework.hls.TranscodeParams;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@BenderBindAllFields
public class TranscodeOverride {
    @Getter
    private final String name;

    private final RequestFilter filter;

    @Getter
    private final TranscodeParams params;

    public TranscodeOverride(String name, RequestFilter filter, TranscodeParams params) {
        this.name = name;
        this.filter = filter;
        this.params = params;
    }

    public boolean matches(MpfsSourceMeta sourceMeta) {
        return filter.matches(sourceMeta);
    }
}
