package ru.yandex.chemodan.app.videostreaming.overrides;

import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@AllArgsConstructor
public class TranscodeOverrideConfig {
    @Qualifier("zkRoot")
    private final ZkPath zkRoot;

    private final ZkManager zkManager;

    @Bean
    public TranscodeParamOverriderProvider transcodeParamOverriderProvider() {
        return new TranscodeParamOverriderProvider(transcodeOverridesRegistry());
    }

    @Bean
    public TranscodeOverridesRegistry transcodeOverridesRegistry() {
        TranscodeOverridesRegistry registry = new TranscodeOverridesRegistry(zkRoot);
        zkManager.addClient(registry);
        return registry;
    }
}
