package ru.yandex.chemodan.app.videostreaming.overrides;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.videostreaming.MpfsSourceMeta;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TranscodeOverridesRegistry extends ZkRegistry<String, TranscodeOverride> {
    private static final BenderParserSerializer<TranscodeOverride> parserSerializer =
            Bender.cons(TranscodeOverride.class);

    public TranscodeOverridesRegistry(ZkPath path) {
        super(path.child("videostreaming/overrides"), parserSerializer, TranscodeOverride::getName,
                Function.identityF());
    }

    public Option<TranscodeOverride> getOverrideO(MpfsSourceMeta sourceMeta) {
        return getAll().find(override -> override.matches(sourceMeta));
    }
}
