package ru.yandex.chemodan.app.videostreaming.overrides;

import ru.yandex.chemodan.app.videostreaming.MpfsSourceMeta;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsParams;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsParamsBySourceOverriderProvider;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TranscodeParamOverriderProvider implements HlsParamsBySourceOverriderProvider<MpfsSourceMeta> {
    private final TranscodeOverridesRegistry overridesRegistry;

    public TranscodeParamOverriderProvider(TranscodeOverridesRegistry overridesRegistry) {
        this.overridesRegistry = overridesRegistry;
    }

    @Override
    public HlsParams.Overrider get(MpfsSourceMeta source) {
        return new OverriderImpl(source);
    }

    private class OverriderImpl implements HlsParams.Overrider {
        final MpfsSourceMeta source;

        public OverriderImpl(MpfsSourceMeta source) {
            this.source = source;
        }

        @Override
        public void override(HlsParams.Overridable overridable) {
            overridesRegistry.getOverrideO(source)
                    .map(TranscodeOverride::getParams)
                    .ifPresent(params ->
                            overridable.withFFmpegCommandParams(b -> b.argFillerName(params.getArgFillerName()))
                                    .withFFmpegParams(b -> {
                                        b.outputLoggingEnabled(params.isFfmpegLogEnabled());
                                        params.getFFmpegVersionO().ifPresent(b::ffmpegVersion);
                                    })
                                    .withStreamingResourceParams(b -> b.enableFullHd(params.isEnableFullHd())
                                            .enableSeparateAudio(params.isEnableSeparateAudio()))
                                    .withStreamingParams(
                                            b -> b.useFloatSegmentDurations(params.isUseFloatSegmentDurations())
                                    )
                    );
        }
    }
}
