package ru.yandex.chemodan.app.videostreaming.upstreams;

import java.io.IOException;
import java.io.OutputStream;

import ru.yandex.chemodan.videostreaming.framework.cachingproxy.ByteRange;
import ru.yandex.chemodan.videostreaming.framework.cachingproxy.ResourceNotFoundException;
import ru.yandex.chemodan.videostreaming.framework.cachingproxy.Upstream;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.mulca.MulcaRange;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.InputStreamX;
import ru.yandex.misc.io.IoUtils;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@SuppressWarnings("unused")
public class MulcaUpstream implements Upstream<MulcaId> {
    private final MulcaClient mulcaClient;

    public MulcaUpstream(MulcaClient mulcaClient) {
        this.mulcaClient = mulcaClient;
    }

    @Override
    public long fetchContentLength(MulcaId resourceId) {
        return mulcaClient.getContentLength(resourceId);
    }

    @Override
    public void downloadTo(MulcaId resourceId, ByteRange range, OutputStream to) throws IOException {
        MulcaRange mulcaRange = new MulcaRange(range.startInclusive, range.endExclusive - 1);
        InputStreamSource iss = mulcaClient.downloadWithRange(resourceId, mulcaRange);
        try(InputStreamX in = iss.getInputStreamX()) {
            IoUtils.copy(in, to);
        } catch (HttpException ex) {
            if (ex.statusCodeIs(HttpStatus.SC_404_NOT_FOUND)) {
                throw new ResourceNotFoundException(ex);
            }
            throw ex;
        }
    }

    @Override
    public MulcaId parse(String value) {
        return MulcaId.fromSerializedString(value);
    }

    @Override
    public String serialize(MulcaId value) {
        return value.toSerializedString();
    }
}
