package ru.yandex.chemodan.app.videostreaming.upstreams;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.chemodan.videostreaming.framework.cachingproxy.ByteRange;
import ru.yandex.chemodan.videostreaming.framework.cachingproxy.ResourceNotFoundException;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.http.HttpException;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class MulcaUpstreamTest {
    @Test(expected = ResourceNotFoundException.class)
    public void throwResourceNotFoundOn404FromMulca() throws IOException {
        exerciseDownloadToWithException(404);
    }

    @Test(expected = HttpException.class)
    public void passThroughHttpExceptionsFromDownloadWithRange() throws IOException {
        exerciseDownloadToWithException(403);
    }

    private void exerciseDownloadToWithException(int statusCode) throws IOException {
        MulcaClient mulcaClientMock = Mockito.mock(MulcaClient.class);
        Mockito.when(mulcaClientMock.downloadWithRange(Mockito.any(), Mockito.any()))
                .thenReturn(consThrowingIss(statusCode));
        MulcaUpstream sut = new MulcaUpstream(mulcaClientMock);

        sut.downloadTo(MulcaId.fromSerializedString("320.14"), new ByteRange(0, 100), new ByteArrayOutputStream());
    }

    private static InputStreamSource consThrowingIss(int statusCode) {
        return new InputStreamSource() {
            @Override
            public InputStream getInput() {
                return new InputStream() {
                    @Override
                    public int read() {
                        throw new HttpException(statusCode);
                    }
                };
            }
        };
    }
}
