package ru.yandex.chemodan.videostreaming.framework.accesscheck;

import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.hls.sourcemeta.SourceMetaParser;
import ru.yandex.misc.ip.IpAddress;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface AccessChecker {
    Result getResult(AccessParams params);

    default Result check(AccessParams params) {
        Result result = getResult(params);
        result.logAndThrowIfAccessDenied();
        return result;
    }

    @Value
    class Result {
        private static final Logger logger = LoggerFactory.getLogger(Result.class);

        String checkName;

        AccessAction action;

        AccessParams params;

        public boolean isAllow() {
            return action == AccessAction.ALLOW;
        }

        void logAndThrowIfAccessDenied() {
            log();
            throwIfAccessDenied();
        }

        private void log() {
            logger.info("Expected IP = {}, request IP = {}, access = {}, check = {}, meta = {}",
                    formatIpO(params.getExpectedIpO()),
                    formatIpO(params.getRequestIpO()),
                    action,
                    checkName,
                    params.getSourceMeta()
            );
        }

        private void throwIfAccessDenied() {
            if (action == AccessAction.DENY) {
                throw new SourceMetaParser.AccessForbiddenException(params.getSourceMeta());
            }
        }

        private static String formatIpO(Option<IpAddress> expectedIpO) {
            return expectedIpO.map(IpAddress::format)
                    .getOrElse("none");
        }

        public boolean isNotNone() {
            return action != AccessAction.NONE;
        }
    }
}
