package ru.yandex.chemodan.videostreaming.framework.accesscheck;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.misc.ip.IpAddress;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class AccessParamsTest {
    @Test
    public void prefetchRequestIsInternal() {
        Assert.isTrue(consFilenameParams("prefetch11.ts").isInternal());
    }

    @Test
    public void localSegmentRequestIsInternal() {
        Assert.isTrue(consFilenameParams("local321.ts").isInternal());
    }

    @Test
    public void segmentRequestIsExternal() {
        Assert.isFalse(consFilenameParams("11.ts").isInternal());
    }

    private static AccessParams consFilenameParams(String filename) {
        return new AccessParams(Option.empty(), Option.empty(), new Object(), filename);
    }

    @Test
    public void bothIpDefinedAndEqual() {
        assertIsTrue(AccessParams::ipsAreEqual,
                Option.of(IpAddress.parse("1.2.3.4")),
                Option.of(IpAddress.parse("1.2.3.4")));
    }

    @Test
    public void bothIpDefinedAndUnequal() {
        assertIsTrue(AccessParams::ipsAreUnequal,
                Option.of(IpAddress.parse("1.2.3.4")),
                Option.of(IpAddress.parse("9.2.3.4")));
    }

    @Test
    public void notDefinedIpsNotEqual() {
        assertIsFalseWhenIpsNotDefined(AccessParams::ipsAreEqual);
    }

    @Test
    public void notDefinedIpsNotUnequal() {
        assertIsFalseWhenIpsNotDefined(AccessParams::ipsAreUnequal);
    }

    private static void assertIsFalseWhenIpsNotDefined(Function1B<AccessParams> ipsAreEqual) {
        assertIsFalse(ipsAreEqual, Option.of(IpAddress.parse("1.2.3.4")), Option.empty());
        assertIsFalse(ipsAreEqual, Option.empty(), Option.of(IpAddress.parse("1.2.3.4")));
        assertIsFalse(ipsAreEqual, Option.empty(), Option.empty());
    }

    private static void assertIsTrue(Function1B<AccessParams> valueProvider,
            Option<IpAddress> expectedIpO, Option<IpAddress> requestIpO)
    {
        Assert.isTrue(valueProvider.apply(consIpsParams(expectedIpO, requestIpO)));
    }

    private static void assertIsFalse(Function1B<AccessParams> valueProvider,
            Option<IpAddress> expectedIpO, Option<IpAddress> requestIpO)
    {
        Assert.isFalse(valueProvider.apply(consIpsParams(expectedIpO, requestIpO)));
    }

    private static AccessParams consIpsParams(Option<IpAddress> expectedIpO, Option<IpAddress> requestIpO) {
        return new AccessParams(expectedIpO, requestIpO, new Object(), "");
    }
}
