package ru.yandex.chemodan.videostreaming.framework.accesscheck;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.ip.IpAddress;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class BasicAccessCheckerTest {
    private static final AccessParams EMPTY_PARAMS = CompositeAccessCheckerTest.EMPTY_PARAMS;

    private static final AccessParams EXPECTED_IP_PARAMS =
            new AccessParams(Option.of(IpAddress.parse("1.2.3.4")), Option.empty(), new Object(), "");

    private static final AccessParams REQUEST_IP_PARAMS =
            new AccessParams(Option.empty(), Option.of(IpAddress.parse("1.2.3.4")), new Object(), "");

    private static final AccessParams BOTH_IP_PARAMS =
            new AccessParams(Option.of(IpAddress.parse("1.2.3.5")), Option.of(IpAddress.parse("1.2.3.4")), new Object(),
                    "");

    @Test
    public void mustReturnSpecifiedActionIfMatchedAndHasDefinedIp() {
        assertActionForIpMaching(AccessAction.ALLOW, true, EXPECTED_IP_PARAMS);
        assertActionForIpMaching(AccessAction.ALLOW, true, REQUEST_IP_PARAMS);
        assertActionForIpMaching(AccessAction.ALLOW,true, BOTH_IP_PARAMS);
    }

    @Test
    public void mustReturnNoneActionIfMatchedAndNoIpDefined() {
        assertActionForIpMaching(AccessAction.NONE, true, EMPTY_PARAMS);
    }

    @Test
    public void mustReturnNoneActionIfHasNoMatch() {
        assertActionForIpMaching(AccessAction.NONE, false, EMPTY_PARAMS);
        assertActionForIpMaching(AccessAction.NONE, false, EXPECTED_IP_PARAMS);
        assertActionForIpMaching(AccessAction.NONE, false, REQUEST_IP_PARAMS);
        assertActionForIpMaching(AccessAction.NONE, false, BOTH_IP_PARAMS);
    }

    private static void assertActionForIpMaching(AccessAction expectedAction, boolean matches, AccessParams params) {
        Assert.equals(expectedAction,
                BasicAccessChecker.allowIfAnyIpMatches("", ip -> matches)
                        .getAction(params)
        );
    }
}
