package ru.yandex.chemodan.videostreaming.framework.accesscheck;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.commune.dynproperties.DynamicPropertyWatcher;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class CompositeAccessChecker implements AccessChecker, DynamicPropertyWatcher<ListF<String>> {
    private final DynamicProperty<ListF<String>> enabledCheckerNames;

    private final MapF<String, BasicAccessChecker> checkers;

    private volatile ListF<BasicAccessChecker> enabledCheckers;

    public CompositeAccessChecker(BasicAccessChecker... checkers) {
        this(Cf.list(checkers));
    }

    public CompositeAccessChecker(ListF<BasicAccessChecker> checkers) {
        this.checkers = checkers.zipWith(BasicAccessChecker::getName).invert().toMap();
        this.enabledCheckers = checkers;
        this.enabledCheckerNames = consEnabledCheckerNamesDynProp(checkers.map(BasicAccessChecker::getName));
    }

    private static DynamicProperty<ListF<String>> consEnabledCheckerNamesDynProp(ListF<String> names) {
        return new DynamicProperty<>("streaming-enabled-access-checkers", names, names::containsAllTs);
    }

    @Override
    public Result getResult(AccessParams params) {
        return enabledCheckers.iterator()
                .map(checker -> checker.getResult(params))
                .find(Result::isNotNone)
                .getOrElse(new Result("composite", AccessAction.NONE, params));
    }

    @Override
    public void updated(ListF<String> checkerNames) {
        enabledCheckers = checkerNames.filterMap(checkers::getO);
    }

    public void register(DynamicPropertyManager dynamicPropertyManager) {
        dynamicPropertyManager.registerAndFireWatcher(enabledCheckerNames, this);
    }
}
