package ru.yandex.chemodan.videostreaming.framework.accesscheck;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.hls.sourcemeta.SourceMetaParser;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class CompositeAccessCheckerTest {
    static final AccessParams EMPTY_PARAMS = new AccessParams(Option.empty(), Option.empty(), new Object(), "");

    @Test
    public void mustPreferAllowIfFirst() {
        assertWasChosen(AccessAction.ALLOW,
                AccessAction.NONE, AccessAction.NONE, AccessAction.ALLOW, AccessAction.NONE, AccessAction.DENY);
        assertWasChosen(AccessAction.ALLOW,
                AccessAction.ALLOW, AccessAction.DENY, AccessAction.NONE, AccessAction.ALLOW);
    }

    @Test
    public void mustPreferDenyIfFirst() {
        assertWasChosen(AccessAction.DENY,
                AccessAction.DENY, AccessAction.NONE, AccessAction.ALLOW, AccessAction.NONE);
        assertWasChosen(AccessAction.DENY,
                AccessAction.NONE, AccessAction.DENY, AccessAction.ALLOW, AccessAction.DENY);
    }

    @Test
    public void useNoneIfNoOtherActions() {
        assertWasChosen(AccessAction.NONE,
                AccessAction.NONE, AccessAction.NONE, AccessAction.NONE, AccessAction.NONE);
    }

    private static void assertWasChosen(AccessAction expectedAction, AccessAction... actions) {
        Assert.equals(expectedAction, consSut(actions).getResult(EMPTY_PARAMS).getAction());
    }

    @Test(expected = SourceMetaParser.AccessForbiddenException.class)
    public void mustThrowAccessForbiddenOnDeny() {
        AccessAction deny = AccessAction.DENY;
        doCheck(deny);
    }

    @Test
    public void mustNotThrowAccessForbiddenOnAllow() {
        doCheck(AccessAction.ALLOW);
    }

    @Test
    public void mustNotThrowAccessForbiddenOnNone() {
        doCheck(AccessAction.NONE);
    }

    private static void doCheck(AccessAction deny) {
        consSut(deny).check(EMPTY_PARAMS);
    }

    private static CompositeAccessChecker consSut(AccessAction... actions) {
        return new CompositeAccessChecker(Cf.list(actions).map(BasicAccessChecker::constant));
    }
}
