package ru.yandex.chemodan.videostreaming.framework.cachingproxy;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.Validate;

/**
 * @author vavinov
 * @author Dmitriy Amelin (lemeh)
 */
public class ByteRange extends DefaultObject {
    public final long startInclusive;
    public final long endExclusive;

    public ByteRange(long startInclusive, long endExclusive) {
        Validate.le(startInclusive, endExclusive);
        this.startInclusive = startInclusive;
        this.endExclusive = endExclusive;
    }

    public long length() {
        return endExclusive - startInclusive;
    }

    public int lengthInt() {
        return (int) length();
    }

    public ByteRange intersectWith(ByteRange other) {
        return new ByteRange(
                Math.max(this.startInclusive, other.startInclusive),
                Math.min(this.endExclusive, other.endExclusive)
        );
    }

    public ByteRange minus(long offset) {
        return new ByteRange(startInclusive - offset, endExclusive - offset);
    }

    public ByteRange shiftStart(long offset) {
        return offset != 0 ? new ByteRange(startInclusive + offset, endExclusive) : this;
    }

    @Override
    public String toString() {
        return startInclusive + "-" + endExclusive;
    }
}
