package ru.yandex.chemodan.videostreaming.framework.cachingproxy;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ByteRangeTest {
    @Test
    public void testShiftStart() {
        Assert.equals(
                new ByteRange(8, 19),
                new ByteRange(6, 19).shiftStart(2)
        );
    }

    @Test
    public void testZeroShiftStart() {
        ByteRange byteRange = new ByteRange(1234, 4567);
        Assert.assertSame(byteRange, byteRange.shiftStart(0));
    }

    @Test
    public void testMinus() {
        Assert.equals(
                new ByteRange(1980, 1983),
                new ByteRange(1983, 1986).minus(3)
        );
    }
}
