package ru.yandex.chemodan.videostreaming.framework.cachingproxy;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
class DownloadRange extends DefaultObject {
    private static final String PREFIX = "bytes=";

    private final long start;

    final Option<Long> endO;

    DownloadRange(long start, long end) {
        this(start, Option.of(end));
    }

    private DownloadRange(long start, Option<Long> end) {
        this.start = start;
        this.endO = end;
    }

    static DownloadRange full() {
        return new DownloadRange(0, Option.empty());
    }

    static DownloadRange parse(String value) {
        ListF<String> chunks =
                Cf.x(value.substring(PREFIX.length())
                        .split("[-,/]"))
                        .take(2);
        return parse(chunks.first(), chunks.getO(1));
    }

    private static DownloadRange parse(String start, Option<String> end) {
        return new DownloadRange(
                Long.parseLong(start.trim()),
                end.map(String::trim)
                        .map(Long::parseLong)
        );
    }

    Long start() {
        return start;
    }

    boolean isPartial(long totalLength) {
        return end(totalLength) - start != totalLength;
    }

    String toContentRange(long totalLength) {
        return String.format("%d-%d/%d", start, end(totalLength), totalLength);
    }

    ByteRange toByteRange(long totalLength) {
        return new ByteRange(start(), end(totalLength));
    }

    long length(long totalLength) {
        return end(totalLength) - start();
    }

    private Long end(long totalLength) {
        return endO.getOrElse(totalLength);
    }
}
