package ru.yandex.chemodan.videostreaming.framework.cachingproxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import org.jetbrains.annotations.NotNull;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class RetryingUpstreamTest {
    @Test
    public void testDownloadToWithRetriesOk() {
        String payload = "Come and get your love";
        Assert.equals(
                payload,
                downloadWithRetries(payload, 2, 2)
        );
    }

    @Test(expected = DownloadFailedException.class)
    public void testDownloadToWithRetriesFail() {
        downloadWithRetries(Random2.threadLocal().nextAlnum(20), 4, 3);
    }

    @NotNull
    private String downloadWithRetries(String payload, int failCount, int retryCount) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RetryingUpstream<String> retryingUpstream = new RetryingUpstream<>(
                consFailingUpstream(payload.getBytes(), failCount),
                retryCount
        );
        retryingUpstream.downloadTo("id", new ByteRange(0, payload.length()), out);
        return new String(out.toByteArray());
    }

    @NotNull
    private Upstream<String> consFailingUpstream(byte[] data, int failCount) {
        SetF<Long> failOnPositions = Random2.threadLocal().randomElements(Cf.range(0, data.length), failCount)
                .map(Integer::longValue)
                .unique();
        return new Upstream<String>() {
                final SetF<Long> failedPositions = Cf.hashSet();

                @Override
                public long fetchContentLength(String resourceId) throws ResourceNotFoundException {
                    return 0;
                }

                @Override
                public void downloadTo(String resourceId, ByteRange range, OutputStream to) throws ResourceNotFoundException, IOException {
                    for(long i = range.startInclusive; i < range.endExclusive; i++) {
                        if (failOnPositions.containsTs(i) && !failedPositions.containsTs(i)) {
                            failedPositions.add(i);
                            throw new DownloadFailedException();
                        }

                        to.write(data[(int) i]);
                    }
                }

                @Override
                public String parse(String value) {
                    return null;
                }

                @Override
                public String serialize(String value) {
                    return null;
                }
            };
    }

    private static class DownloadFailedException extends RuntimeException {

    }
}
