package ru.yandex.chemodan.videostreaming.framework.cachingproxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import org.junit.Test;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class StorageProxyManagerTest {
    private static final String STRING = "People who live in glass houses should not throw stones";

    @Test
    public void whenChunkSizeIsLargerThanContentLength() {
        test("People", DataSize.fromBytes(STRING.length() + 1000), 0, 6);
    }

    @Test
    public void whenStartOfTheSingleChunk() {
        test("People who live", DataSize.fromBytes(20), 0, 15);
    }

    @Test
    public void whenEndOfTheSingleChunk() {
        test("stones", DataSize.fromBytes(20), 49, 55);
    }

    @Test
    public void whenBetweenPartialChunksWithFullInTheMiddle() {
        test("glass houses", DataSize.fromBytes(3), 19, 31);
    }

    private static void test(String expectedValue, DataSize chunkSize, int start, int end) {
        StorageProxyManager<String> manager =
                new StorageProxyManager<>(new StringUpstream(), 100000, chunkSize);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        manager.getSession("some id")
                .transferTo(baos, new DownloadRange(start, end));
        Assert.equals(expectedValue, new String(baos.toByteArray()));
    }

    private static class StringUpstream implements Upstream<String> {
        @Override
        public long fetchContentLength(String resourceId) {
            return STRING.length();
        }

        @Override
        public void downloadTo(String resourceId, ByteRange range, OutputStream to) throws IOException {
            try {
                Thread.sleep(50);
            } catch (InterruptedException e) {
                throw ExceptionUtils.translate(e);
            }
            to.write(STRING.substring((int) range.startInclusive, (int) range.endExclusive).getBytes());
        }

        @Override
        public String parse(String value) {
            return value;
        }

        @Override
        public String serialize(String value) {
            return value;
        }
    }
}
