package ru.yandex.chemodan.videostreaming.framework.cachingproxy;

import java.io.IOException;
import java.io.OutputStream;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface Upstream<T> {
    long fetchContentLength(T resourceId) throws ResourceNotFoundException;

    void downloadTo(T resourceId, ByteRange range, OutputStream to) throws ResourceNotFoundException, IOException;

    T parse(String value);

    String serialize(T value);
}
